using System;
using System.Configuration;
using System.Data.SqlClient;
using System.Data;
using gov.va.med.vbecs.Common.AppServices;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/22/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Global configuration class providing type-safe access to application configuration file.
	/// </summary>

	#endregion

    public class VbecsConfig
    {
        /// <summary>
        /// Name of the VBECS resource assembly. Needed in various places to load resources directly from the assembly. 
        /// </summary>
        public const string ResourceAssemblyName = "VBECS.AppResources";

        private const string CONFIG_KEY_DB_QUERY_TIMEOUT = "DbQueryTimeoutSeconds";
        private const string CONFIG_KEY_FILE_NAME = "ErrorLogFileName";
        private const string CONFIG_ENVIRONMENT_TYPE = "VbecsEnvironmentType";
        private const string CONFIG_KEY_USER_DOMAIN_GROUP_NAME = "VbecsUsersDomainGroupName";
        private const string CONFIG_KEY_ADMIN_DOMAIN_GROUP_NAME = "VbecsAdminDomainGroupName";
        private const string CONFIG_KEY_DATE_FORMAT = "dateFormat";
        private const string CONFIG_KEY_DATE_TIME_FORMAT = "dateTimeFormat";
        private const string CONFIG_KEY_LONG_DATE_TIME_FORMAT = "dateTimeLongFormat";
        private const string CONFIG_KEY_TIME_FORMAT = "timeFormat";
        private const string CONFIG_KEY_LONG_TIME_FORMAT = "timeLongFormat";
        private const string CONFIG_KEY_VISTA_CACHE_REFRESH_INTERVAL = "VistACacheRefreshIntervalInMinutes";
        private const string CONFIG_KEY_ERROR_PROVIDER_SPEAK_DELAY_IN_MILLISECONDS = "ErrorProviderSpeakDelayInMilliseconds"; // **** 508 Compliance ***
        private const string CONFIG_KEY_DOMAIN = "Domain";// **** 508 Compliance ***
        private const string CONFIG_KEY_REPORT_EXPORT_PATH = "ReportExportPath";
        private const string CONFIG_KEY_ENVIRONMENT_TYPE = "VbecsEnvironmentType";

        private static VbecsConfig _currentConfig;

        private string _primaryDbConnectionString;
        private string _errorLogFileName;
        private string _environmentType;
        private string _userDomainGroupName;
        private string _adminDomainGroupName;
        private string _dateFormat;
        private string _dateTimeFormat;
        private string _longDateTimeFormat;
        private string _timeFormat;
        private string _longTimeFormat;
        private string _domain;
        private string _reportExportPath;

        private int _dbQueryTimeoutSeconds;
        private int _vistACacheRefreshIntervalInMinutes;
        private int _errorProviderSpeakDelayInMilliseconds; // **** 508 Compliance ***

        private static bool _dbConnectionStringError = false;      //Needed to avoid crash on Exception.Publish() so a detailed msg can be displayed to users
        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3865"> 
        ///		<ExpectedInput>None</ExpectedInput>
        ///		<ExpectedOutput>Initialized object</ExpectedOutput>
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1610"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Constructor setting default configuration values. 
        /// Safety stub in case VBECS app config file is not present or damaged.
        /// </summary>
        public VbecsConfig()
        {
            _primaryDbConnectionString = null;
            _dbQueryTimeoutSeconds = 30;
            _dateFormat = "MM/dd/yyyy";
            _dateTimeFormat = "MM/dd/yyyy HH:mm";
            _longDateTimeFormat = "MM/dd/yyyy HH:mm:ss";
            _timeFormat = "HH:mm";
            _longTimeFormat = "HH:mm:ss";
            _errorLogFileName = string.Empty;
            _environmentType = string.Empty;
            _userDomainGroupName = string.Empty;
            _adminDomainGroupName = string.Empty;
            _errorProviderSpeakDelayInMilliseconds = 15000;
            _domain = string.Empty;
            _reportExportPath = string.Empty;
        }

        ///<Developers>
        ///	<Developer>Jason Engstrom</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>9/12/2005</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8222"> 
        ///		<ExpectedInput>Valid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///<Case type="1" testid ="8223"> 
        ///		<ExpectedInput>Invalid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// VbecsUserDomainGroupName
        /// </summary>
        public string VbecsUserDomainGroupName
        {
            get
            {
                return _userDomainGroupName;
            }
        }

        ///<Developers>
        ///	<Developer>Jason Engstrom</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>9/21/2005</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8309"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>string</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///<Case type="1" testid ="8310"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// VbecsAdminDomainGroupName
        /// </summary>
        public string VbecsAdminDomainGroupName
        {
            get
            {
                return _adminDomainGroupName;
            }
        }


        ///<Developers>
        ///	<Developer>Rob Heiberger</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>12/22/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="6005"> 
        ///		<ExpectedInput>Valid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="6006"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Error log file name
        /// </summary>
        public string ErrorLogFileName
        {
            get
            {
                return _errorLogFileName;
            }
        }

        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3875"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Non-empty string.</ExpectedOutput>
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1652"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Primary VBECS database connection string.
        /// </summary>
        public string PrimaryDbConnectionString
        {
            get
            {
                return _primaryDbConnectionString;
            }
        }

        ///<Developers>
        ///	<Developer>Jason Engstrom</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>9/12/2005</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8226"> 
        ///		<ExpectedInput>Valid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///<Case type="1" testid ="8227"> 
        ///		<ExpectedInput>Invalid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Database query timeout in seconds. 
        /// </summary>
        public int DbQueryTimeoutSeconds
        {
            get
            {
                return _dbQueryTimeoutSeconds;
            }
        }

        ///<Developers>
        ///	<Developer>D. Askew</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>2/21/2006</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8395"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>int</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="8396"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// VistACacheRefreshInterval
        /// </summary>
        public int VistACacheRefreshInterval
        {
            get
            {
                return _vistACacheRefreshIntervalInMinutes;
            }
        }

        ///<Developers>
        ///	<Developer>saic</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>12/9/2009</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8951"> 
        ///		<ExpectedInput>Valid</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="8952"> 
        ///		<ExpectedInput>Invalid</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// **** 508 Compliance ***
        /// </summary>
        public int ErrorProviderSpeakDelayInMilliseconds
        {
            get
            {
                return _errorProviderSpeakDelayInMilliseconds;
            }
        }

        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3870"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Non-empty string.</ExpectedOutput>		
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1675"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Application's date string format.
        /// </summary>
        public string DateFormat
        {
            get
            {
                return _dateFormat;
            }
        }

        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3871"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Non-empty string.</ExpectedOutput>		
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1707"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Application's date and time string format.
        /// </summary>
        public string DateTimeFormat
        {
            get
            {
                return _dateTimeFormat;
            }
        }

        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3872"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Non-empty string.</ExpectedOutput>		
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1724"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Application's long date and time string format.
        /// </summary>
        public string LongDateTimeFormat
        {
            get
            {
                return _longDateTimeFormat;
            }
        }

        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3873"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Non-empty string.</ExpectedOutput>		
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1729"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Application's time string format.
        /// </summary>
        public string TimeFormat
        {
            get
            {
                return _timeFormat;
            }
        }

        ///<Developers>
        ///	<Developer>Stas Antropov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/5/2004</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="3874"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Non-empty string.</ExpectedOutput>		
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1731"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Application's long time string format.
        /// </summary>
        public string LongTimeFormat
        {
            get
            {
                return _longTimeFormat;
            }
        }

        ///<Developers>
        ///	<Developer>Jason Engstrom</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>9/12/2005</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8228"> 
        ///		<ExpectedInput>Valid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///<Case type="1" testid ="8229"> 
        ///		<ExpectedInput>Invalid Parameters</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Application environment type (Production or Mirror)
        /// </summary>
        public string EnvironmentType
        {
            get
            {
                return _environmentType;
            }
        }

        /// <summary>
        /// Domain
        /// </summary>
        public string Domain
        {
            get
            {
                return _domain;
            }
        }

        /// <summary>
        /// ReportExportPath
        /// </summary>
        public string ReportExportPath
        {
            get
            {
                if (_reportExportPath != "")
                    return _reportExportPath;
                else return "c:\\temp\\";
            }
        }

        ///	<Developers>
        ///		<Developer>Stas Antropov</Developer>
        ///	</Developers>
        ///	<SiteName>Hines OIFO</SiteName>
        ///	<CreationDate>3/5/2004</CreationDate>
        ///	<TestCases>
        ///	
        ///<Case type="0" testid ="3867"> 
        ///		<ExpectedInput>None.</ExpectedInput>
        ///		<ExpectedOutput>Config object.</ExpectedOutput>
        ///	</Case>
        ///	
        ///<Case type="1" testid ="1651"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///	</TestCases>
        ///	<Update></Update>
        ///	<ArchivePlan></ArchivePlan>
        ///	<Interfaces></Interfaces>
        /// <summary>
        /// Current VBECS configuration.
        /// </summary>
        public static VbecsConfig Current
        {
            get
            {
                if (_currentConfig == null)
                    _currentConfig = VbecsConfig.GetSettingsFromAppConfig();

                return _currentConfig;
            }
        }

        /// <summary>
        /// Retrieves VBECS settings from application configuration file
        /// mapping it to config class variables.
        /// </summary>
        /// <returns>Newly created config object initialized with config file values.</returns>
        private static VbecsConfig GetSettingsFromAppConfig()
        {
            VbecsConfig config = new VbecsConfig();

            if (!_dbConnectionStringError)      //Added to avoid a nested/lost failure if there is a something wrong with the config file
            {
                config._primaryDbConnectionString = Container.GlobalContext.DbSettingsReader.PrimaryDbConnectionString;
                _currentConfig = config;
                // Reset code to use orginal method. 
                // Because it sets the default if not found, otherwise it overwrites the default with empty string.
                GetConfigValueFromDB(CONFIG_KEY_DB_QUERY_TIMEOUT, ref config._dbQueryTimeoutSeconds);
                GetConfigValueFromDB(CONFIG_KEY_DATE_FORMAT, ref config._dateFormat);
                GetConfigValueFromDB(CONFIG_KEY_DATE_TIME_FORMAT, ref config._dateTimeFormat);
                GetConfigValueFromDB(CONFIG_KEY_LONG_DATE_TIME_FORMAT, ref config._longDateTimeFormat);
                GetConfigValueFromDB(CONFIG_KEY_LONG_TIME_FORMAT, ref config._longTimeFormat);
                GetConfigValueFromDB(CONFIG_KEY_TIME_FORMAT, ref config._timeFormat);
                GetConfigValueFromDB(CONFIG_KEY_USER_DOMAIN_GROUP_NAME, ref config._userDomainGroupName);
                GetConfigValueFromDB(CONFIG_KEY_ADMIN_DOMAIN_GROUP_NAME, ref config._adminDomainGroupName);
                GetConfigValueFromDB(CONFIG_KEY_VISTA_CACHE_REFRESH_INTERVAL, ref config._vistACacheRefreshIntervalInMinutes);
                GetConfigValueFromDB(CONFIG_KEY_ERROR_PROVIDER_SPEAK_DELAY_IN_MILLISECONDS, ref config._errorProviderSpeakDelayInMilliseconds); // **** 508 Compliance ***
                GetConfigValueFromDB(CONFIG_KEY_DOMAIN, ref config._domain);


                config._errorLogFileName = GetConfigValueFromDB(CONFIG_KEY_FILE_NAME, ApplicationNameGlobalConfig.Vbecs);
                config._environmentType = GetConfigValueFromDB(CONFIG_KEY_ENVIRONMENT_TYPE, ApplicationNameGlobalConfig.Vbecs);
                config._reportExportPath = GetConfigValueFromDB(CONFIG_KEY_REPORT_EXPORT_PATH, ApplicationNameGlobalConfig.Vbecs);
            }
            return config;
        }

        /// <summary>
        /// Checks if value indentified by a given key exists in application configuration file
        /// and if it does, retrieves it and sets it to a given value holder. 
        /// The method does not alter value holder if value does not exists in config file.
        /// </summary>
        /// <param name="configKey">Application configuration file string key.</param>
        /// <param name="valueHolder">Reference to member variable to initialize with configuration file value.</param>
        private static void GetConfigValueFromDB(string configKey, ref string valueHolder)
        {
            if (configKey == null)
                throw (new ArgumentNullException("configKey"));

            if (valueHolder == null)
                throw (new ArgumentNullException("valueHolder"));

            SqlParameter[] prms =
			{
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ApplicationName, SqlDbType.VarChar),
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ParameterName, SqlDbType.VarChar)
			};

            prms[0].Value = Common.Utility.GetApplicationNameGlobalConfigStringFromEnum(Common.ApplicationNameGlobalConfig.Vbecs);
            prms[1].Value = configKey;

            DataTable dtParam = Common.StoredProcedure.GetData(VbecsStoredProcs.GetVbecsGlobalConfigValue.StoredProcName, prms).Tables[0];

            string _configValue = null;

            if (dtParam.Rows.Count == 1)
            {
                _configValue = dtParam.Rows[0][VbecsTables.VbecsGlobalConfig.ParameterValue].ToString();
            }

            if (_configValue != null)
                valueHolder = _configValue;
        }

        /// <summary>
        /// Checks if value indentified by a given key exists in application configuration file
        /// and if it does, retrieves it and sets it to a given value holder. 
        /// The method does not alter value holder if value does not exists in config file.
        /// </summary>
        /// <param name="configKey">Application configuration file string key.</param>
        /// <param name="valueHolder">Reference to member variable to initialize with configuration file value.</param>
        private static void GetConfigValueFromDB(string configKey, ref int valueHolder)
        {
            if (configKey == null)
                throw (new ArgumentNullException("configKey"));

            SqlParameter[] prms =
			{
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ApplicationName, SqlDbType.VarChar),
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ParameterName, SqlDbType.VarChar)
			};

            prms[0].Value = Common.Utility.GetApplicationNameGlobalConfigStringFromEnum(Common.ApplicationNameGlobalConfig.Vbecs);
            prms[1].Value = configKey;

            DataTable dtParam = Common.StoredProcedure.GetData(VbecsStoredProcs.GetVbecsGlobalConfigValue.StoredProcName, prms).Tables[0];

            string _configValue = null;

            if (dtParam.Rows.Count == 1)
            {
                _configValue = dtParam.Rows[0][VbecsTables.VbecsGlobalConfig.ParameterValue].ToString();
            }

            if (_configValue != null)
                valueHolder = Int32.Parse(_configValue);
        }

        /// <summary>
        /// Retrieves value from application configuration file if a value exists under a specified key.
        /// </summary>
        /// <param name="configKey">Config key.</param>
        /// <param name="appName">Application name such as VBECS</param>
        /// <returns>Value or String.Empty.</returns>
        public static string GetConfigValueFromDB(string configKey, Common.ApplicationNameGlobalConfig appName)
        {
            if (configKey == null)
                throw (new ArgumentNullException("configKey"));

            SqlParameter[] prms =
			{
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ApplicationName, SqlDbType.VarChar),
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ParameterName, SqlDbType.VarChar)
			};

            prms[0].Value = Common.Utility.GetApplicationNameGlobalConfigStringFromEnum(appName);
            prms[1].Value = configKey;

            DataTable dtParam = Common.StoredProcedure.GetData(VbecsStoredProcs.GetVbecsGlobalConfigValue.StoredProcName, prms).Tables[0];

            object _configValue = null;

            if (dtParam.Rows.Count == 1)
            {
                _configValue = dtParam.Rows[0][VbecsTables.VbecsGlobalConfig.ParameterValue];
            }

            if (_configValue != null)
                return _configValue.ToString();
            else
                return string.Empty;
        }

        /// <summary>
        /// Retrieves all configuration rows for an application guration file if a value exists under a specified key.
        /// </summary>
        /// <param name="appName">Application name such as VBECS</param>
        /// <returns>Value or String.Empty.</returns>
        public static System.Data.DataTable GetAllVbecsGlobalConfigForApp(Common.ApplicationNameGlobalConfig appName)
        {
            SqlParameter[] prms =
			{
				new SqlParameter(VbecsStoredProcs.GetVbecsGlobalConfigValue.ApplicationName, SqlDbType.VarChar)
			};

            prms[0].Value = Common.Utility.GetApplicationNameGlobalConfigStringFromEnum(appName);


            DataTable dtParam = Common.StoredProcedure.GetData(VbecsStoredProcs.GetAllVbecsGlobalConfigValue.StoredProcName, prms).Tables[0];

            return dtParam;
        }

     }
}